/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettingsHandleBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class ServerFilteringBehaviour
extends BlockEntityBehaviour<SmartBlockEntity>
implements ValueSettingsHandleBehaviour {
    public static final BehaviourType<ServerFilteringBehaviour> TYPE = new BehaviourType();
    protected FilterItemStack filter;
    boolean showCount = false;
    public int count = 64;
    public boolean upTo = true;
    private Predicate<class_1799> predicate = stack -> true;
    private Consumer<class_1799> callback = stack -> {};
    private Supplier<Boolean> showCountPredicate = () -> this.showCount;
    private Supplier<Boolean> isActive = () -> true;
    boolean recipeFilter = false;
    public boolean fluidFilter = false;

    public ServerFilteringBehaviour(SmartBlockEntity be) {
        super(be);
        this.filter = FilterItemStack.empty();
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71468("Filter", FilterItemStack.CODEC, (Object)this.filter);
        view.method_71465("FilterAmount", this.count);
        view.method_71472("UpTo", this.upTo);
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.filter = view.method_71426("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        this.count = view.method_71424("FilterAmount", 0);
        this.upTo = view.method_71433("UpTo", false);
        if (this.count == 0) {
            this.upTo = true;
            this.count = this.getMaxStackSize();
        }
        super.read(view, clientPacket);
    }

    public ServerFilteringBehaviour withCallback(Consumer<class_1799> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public ServerFilteringBehaviour withPredicate(Predicate<class_1799> filterPredicate) {
        this.predicate = filterPredicate;
        return this;
    }

    public ServerFilteringBehaviour forRecipes() {
        this.recipeFilter = true;
        return this;
    }

    public ServerFilteringBehaviour forFluids() {
        this.fluidFilter = true;
        return this;
    }

    public ServerFilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        this.showCountPredicate = condition;
        return this;
    }

    public ServerFilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public boolean setFilter(class_2350 face, class_1799 stack) {
        return this.setFilter(stack);
    }

    public boolean setFilter(class_1799 stack) {
        class_1799 filter = stack.method_7972();
        if (!filter.method_7960() && !this.predicate.test(filter)) {
            return false;
        }
        this.filter = FilterItemStack.of(filter);
        if (!this.upTo && !stack.method_7960()) {
            this.count = Math.min(this.count, stack.method_7914());
        }
        this.callback.accept(filter);
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        return true;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = class_3532.method_15340((int)settings.value(), (int)1, (int)this.getMaxStackSize());
        this.upTo = settings.row() == 0;
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(this.upTo ? 0 : 1, this.count == 0 ? this.getMaxStackSize() : this.count);
    }

    @Override
    public void destroy() {
        if (this.filter.isFilterItem()) {
            class_243 pos = VecHelper.getCenterOf((class_2382)this.getPos());
            class_1937 world = this.getLevel();
            world.method_8649((class_1297)new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, this.getFilter().method_7972()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (this.filter.isFilterItem()) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.getFilter());
        }
        return ItemRequirement.NONE;
    }

    public int getMaxStackSize() {
        return this.getMaxStackSize(this.getFilter());
    }

    public int getMaxStackSize(class_2350 face) {
        return this.getMaxStackSize(this.getFilter(face));
    }

    public int getMaxStackSize(class_1799 filter) {
        if (filter.method_7960()) {
            return 64;
        }
        return filter.method_7914();
    }

    public class_1799 getFilter(class_2350 side) {
        return this.getFilter();
    }

    public class_1799 getFilter() {
        return this.filter.item();
    }

    public boolean isCountVisible() {
        return this.showCountPredicate.get() != false && this.getMaxStackSize() > 1;
    }

    public boolean test(class_1799 stack) {
        return !this.isActive() || this.filter.test(this.blockEntity.method_10997(), stack);
    }

    public boolean test(FluidStack stack) {
        return !this.isActive() || this.filter.test(this.blockEntity.method_10997(), stack);
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public ServerFilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    @Override
    public String getClipboardKey() {
        return "Filtering";
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        ValueSettingsHandleBehaviour.super.writeToClipboard(view, side);
        class_1799 filter = this.getFilter(side);
        view.method_71468("Filter", class_1799.field_49266, (Object)filter);
        return true;
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        if (!this.mayInteract(player)) {
            return false;
        }
        boolean upstreamResult = ValueSettingsHandleBehaviour.super.readFromClipboard(view, player, side, simulate);
        Optional filterItem = view.method_71426("Filter", class_1799.field_49266);
        if (filterItem.isEmpty()) {
            return upstreamResult;
        }
        if (simulate) {
            return true;
        }
        if (this.getLevel().method_8608()) {
            return true;
        }
        class_1799 refund = class_1799.field_8037;
        class_1799 filter = this.getFilter(side);
        if (filter.method_7909() instanceof FilterItem && !player.method_68878()) {
            refund = filter.method_7972();
        }
        class_1799 copied = (class_1799)filterItem.get();
        class_1661 inventory = player.method_31548();
        class_1792 class_17922 = copied.method_7909();
        if (class_17922 instanceof FilterItem) {
            FilterItem filterType = (FilterItem)class_17922;
            if (!player.method_68878()) {
                if (refund.method_7909() == filterType) {
                    this.setFilter(side, copied);
                    return true;
                }
                if (inventory.extract(filterType.method_7854()) == 1 || !inventory.extract(stack -> stack.method_7909() == filterType, 1).method_7960()) {
                    if (!refund.method_7960()) {
                        inventory.method_7398(refund);
                    }
                    this.setFilter(side, copied);
                    return true;
                }
                player.method_7353((class_2561)class_2561.method_43469((String)"create.logistics.filter.requires_item_in_inventory", (Object[])new Object[]{copied.method_7964().method_27661().method_27692(class_124.field_1068)}).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.playOnServer(player.method_73183(), (class_2382)player.method_24515(), 1.0f, 1.0f);
                return false;
            }
        }
        if (!refund.method_7960()) {
            inventory.method_7398(refund);
        }
        return this.setFilter(side, copied);
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        class_1937 level = this.getLevel();
        class_2338 pos = this.getPos();
        class_1799 itemInHand = player.method_5998(hand);
        class_1799 toApply = itemInHand.method_7972();
        if (!this.canShortInteract(toApply)) {
            return;
        }
        if (level.method_8608()) {
            return;
        }
        class_1799 filter = this.getFilter(side);
        if (filter.method_7909() instanceof FilterItem) {
            class_1661 inventory = player.method_31548();
            if (!player.method_68878() || inventory.count(filter, 1) == 0) {
                inventory.method_7398(filter.method_7972());
            }
        }
        if (toApply.method_7909() instanceof FilterItem) {
            toApply.method_7939(1);
        }
        if (!this.setFilter(side, toApply)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"create.logistics.filter.invalid_item"), true);
            AllSoundEvents.DENY.playOnServer(player.method_73183(), (class_2382)player.method_24515(), 1.0f, 1.0f);
            return;
        }
        if (!player.method_68878() && toApply.method_7909() instanceof FilterItem) {
            if (itemInHand.method_7947() == 1) {
                player.method_6122(hand, class_1799.field_8037);
            } else {
                itemInHand.method_7934(1);
            }
        }
        level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 0.25f, 0.1f);
    }

    public boolean canShortInteract(class_1799 toApply) {
        if (toApply.method_31574((class_1792)AllItems.WRENCH)) {
            return false;
        }
        return !toApply.method_31574((class_1792)AllItems.MECHANICAL_ARM);
    }

    public boolean isRecipeFilter() {
        return this.recipeFilter;
    }

    @Override
    public int netId() {
        return 1;
    }

    public static class CustomInteract
    extends ServerFilteringBehaviour {
        @Nullable
        private final List<class_1792> blackList;

        public CustomInteract(SmartBlockEntity be, List<class_1792> blackList) {
            super(be);
            this.blackList = blackList;
        }

        public CustomInteract(SmartBlockEntity be) {
            this(be, null);
        }

        @Override
        public boolean canShortInteract(class_1799 toApply) {
            if (this.blackList != null) {
                for (class_1792 item : this.blackList) {
                    if (!toApply.method_31574(item)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

